#ifdef PRECOMPILEDHEADERS
	#include "TileEngine All.h"
#else
	#include "types.h"
	#include "pits.h"
	#include "worlddef.h"
	#include "worldman.h"
	#include "Simple Render Utils.h"
	#include "World Items.h"
	#include "SaveLoadMap.h"
	#include "Exit Grids.h"
	#include "Sys Globals.h"
	#include "strategicmap.h"
	#include "Isometric Utils.h"
	#include "overhead.h"
	#include "Sound Control.h"
	#include "animation control.h"
	#include "strategic.h"
	#include "Action Items.h"
#endif

//used by editor
BOOLEAN gfShowPits = FALSE;

BOOLEAN gfLoadPitsWithoutArming = FALSE;

void Add3X3Pit( INT32 iMapIndex )
{
	EXITGRID ExitGrid;
	if( !gfEditMode )
		ApplyMapChangesToMapTempFile( TRUE );
	AddObjectToTail( iMapIndex + 159, gFirstTileOfType[REGWATERTEXTURE]+0 );
	AddObjectToTail( iMapIndex -   1, gFirstTileOfType[REGWATERTEXTURE]+1 );
	AddObjectToTail( iMapIndex - 161, gFirstTileOfType[REGWATERTEXTURE]+2 );
	AddObjectToTail( iMapIndex + 160, gFirstTileOfType[REGWATERTEXTURE]+3 );
	AddObjectToTail( iMapIndex,		 gFirstTileOfType[REGWATERTEXTURE]+4 );
	AddObjectToTail( iMapIndex - 160, gFirstTileOfType[REGWATERTEXTURE]+5 );
	AddObjectToTail( iMapIndex + 161, gFirstTileOfType[REGWATERTEXTURE]+6 );
	AddObjectToTail( iMapIndex +   1, gFirstTileOfType[REGWATERTEXTURE]+7 );
	AddObjectToTail( iMapIndex - 159, gFirstTileOfType[REGWATERTEXTURE]+8 );
	if( !gfEditMode )
	{ //Add the exitgrids associated with the pit.
		ExitGrid.ubGotoSectorX = (UINT8)gWorldSectorX;
		ExitGrid.ubGotoSectorY = (UINT8)gWorldSectorY;
		ExitGrid.ubGotoSectorZ = (UINT8)(gbWorldSectorZ+1);
		ExitGrid.usGridNo = (UINT16)iMapIndex;
		AddExitGridToWorld( iMapIndex + 159, &ExitGrid );
		AddExitGridToWorld( iMapIndex -   1, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 161, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 160, &ExitGrid );
		AddExitGridToWorld( iMapIndex,			 &ExitGrid );
		AddExitGridToWorld( iMapIndex - 160, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 161, &ExitGrid );
		AddExitGridToWorld( iMapIndex +   1, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 159, &ExitGrid );
		RecompileLocalMovementCostsFromRadius( (INT16)iMapIndex, 2 );
	}

	MarkWorldDirty();
	if( !gfEditMode )
		ApplyMapChangesToMapTempFile( FALSE );
}

void Add5X5Pit( INT32 iMapIndex )
{
	EXITGRID ExitGrid;
	if( !gfEditMode )
		ApplyMapChangesToMapTempFile( TRUE );
	AddObjectToTail( iMapIndex + 318, gFirstTileOfType[REGWATERTEXTURE]+9 );
	AddObjectToTail( iMapIndex + 158, gFirstTileOfType[REGWATERTEXTURE]+10 );
	AddObjectToTail( iMapIndex -   2, gFirstTileOfType[REGWATERTEXTURE]+11 );
	AddObjectToTail( iMapIndex - 162, gFirstTileOfType[REGWATERTEXTURE]+12 );
	AddObjectToTail( iMapIndex - 322, gFirstTileOfType[REGWATERTEXTURE]+13 );
	AddObjectToTail( iMapIndex + 319, gFirstTileOfType[REGWATERTEXTURE]+14 );
	AddObjectToTail( iMapIndex + 159, gFirstTileOfType[REGWATERTEXTURE]+15 );
	AddObjectToTail( iMapIndex -   1, gFirstTileOfType[REGWATERTEXTURE]+16 );
	AddObjectToTail( iMapIndex - 161, gFirstTileOfType[REGWATERTEXTURE]+17 );
	AddObjectToTail( iMapIndex - 321, gFirstTileOfType[REGWATERTEXTURE]+18 );
	AddObjectToTail( iMapIndex + 320, gFirstTileOfType[REGWATERTEXTURE]+19 );
	AddObjectToTail( iMapIndex + 160, gFirstTileOfType[REGWATERTEXTURE]+20 );
	AddObjectToTail( iMapIndex,		 gFirstTileOfType[REGWATERTEXTURE]+21 );
	AddObjectToTail( iMapIndex - 160, gFirstTileOfType[REGWATERTEXTURE]+22 );
	AddObjectToTail( iMapIndex - 320, gFirstTileOfType[REGWATERTEXTURE]+23 );
	AddObjectToTail( iMapIndex + 321, gFirstTileOfType[REGWATERTEXTURE]+24 );
	AddObjectToTail( iMapIndex + 161, gFirstTileOfType[REGWATERTEXTURE]+25 );
	AddObjectToTail( iMapIndex +   1, gFirstTileOfType[REGWATERTEXTURE]+26 );
	AddObjectToTail( iMapIndex - 159, gFirstTileOfType[REGWATERTEXTURE]+27 );
	AddObjectToTail( iMapIndex - 319, gFirstTileOfType[REGWATERTEXTURE]+28 );
	AddObjectToTail( iMapIndex + 322, gFirstTileOfType[REGWATERTEXTURE]+29 );
	AddObjectToTail( iMapIndex + 162, gFirstTileOfType[REGWATERTEXTURE]+30 );
	AddObjectToTail( iMapIndex +   2, gFirstTileOfType[REGWATERTEXTURE]+31 );
	AddObjectToTail( iMapIndex - 158, gFirstTileOfType[REGWATERTEXTURE]+32 );
	AddObjectToTail( iMapIndex - 318, gFirstTileOfType[REGWATERTEXTURE]+33 );
	if( !gfEditMode )
	{ //Add the exitgrids associated with the pit.
		ExitGrid.ubGotoSectorX = (UINT8)gWorldSectorX;
		ExitGrid.ubGotoSectorY = (UINT8)gWorldSectorY;
		ExitGrid.ubGotoSectorZ = (UINT8)(gbWorldSectorZ+1);
		ExitGrid.usGridNo = (UINT16)iMapIndex;
		AddExitGridToWorld( iMapIndex + 318, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 158, &ExitGrid );
		AddExitGridToWorld( iMapIndex -   2, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 162, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 322, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 319, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 159, &ExitGrid );
		AddExitGridToWorld( iMapIndex -   1, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 161, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 321, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 320, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 160, &ExitGrid );
		AddExitGridToWorld( iMapIndex,			 &ExitGrid );
		AddExitGridToWorld( iMapIndex - 160, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 320, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 321, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 161, &ExitGrid );
		AddExitGridToWorld( iMapIndex +   1, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 159, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 319, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 322, &ExitGrid );
		AddExitGridToWorld( iMapIndex + 162, &ExitGrid );
		AddExitGridToWorld( iMapIndex +   2, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 158, &ExitGrid );
		AddExitGridToWorld( iMapIndex - 318, &ExitGrid );
		RecompileLocalMovementCostsFromRadius( (INT16)iMapIndex, 3 );
	}
	MarkWorldDirty();
	if( !gfEditMode )
		ApplyMapChangesToMapTempFile( FALSE );
}

void Remove3X3Pit( INT32 iMapIndex )
{
	RemoveAllObjectsOfTypeRange( iMapIndex + 159, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex -   1,	REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 161, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 160, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex,				REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 160, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 161, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex +   1, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 159, REGWATERTEXTURE, REGWATERTEXTURE );
	MarkWorldDirty();
}

void Remove5X5Pit( INT32 iMapIndex )
{
	RemoveAllObjectsOfTypeRange( iMapIndex + 318, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 158, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex -   2, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 162, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 322, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 319, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 159, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex -   1, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 161, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 321, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 320, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 160, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex,				REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 160, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 320, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 321, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 161, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex +   1, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 159, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 319, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 322, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex + 162, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex +   2, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 158, REGWATERTEXTURE, REGWATERTEXTURE );
	RemoveAllObjectsOfTypeRange( iMapIndex - 318, REGWATERTEXTURE, REGWATERTEXTURE );
	MarkWorldDirty();
}

void AddAllPits()
{
	UINT32 i;
	for( i = 0; i < guiNumWorldItems; i++ )
	{
		if( gWorldItems[ i ].o.usItem == ACTION_ITEM )
		{
			if( gWorldItems[ i ].o.bActionValue == ACTION_ITEM_SMALL_PIT )
				Add3X3Pit( gWorldItems[ i ].sGridNo );		
			else if( gWorldItems[ i ].o.bActionValue == ACTION_ITEM_LARGE_PIT )
				Add5X5Pit( gWorldItems[ i ].sGridNo );
		}	
	}
}

void RemoveAllPits()
{
	UINT32 i;
	for( i = 0; i < guiNumWorldItems; i++ )
	{
		if( gWorldItems[ i ].o.usItem == ACTION_ITEM )
		{
			if( gWorldItems[ i ].o.bActionValue == ACTION_ITEM_SMALL_PIT )
				Remove3X3Pit( gWorldItems[ i ].sGridNo );		
			else if( gWorldItems[ i ].o.bActionValue == ACTION_ITEM_LARGE_PIT )
				Remove5X5Pit( gWorldItems[ i ].sGridNo );
		}	
	}
}

void SearchForOtherMembersWithinPitRadiusAndMakeThemFall( INT16 sGridNo, INT16 sRadius )
{
	INT16 x, y, sNewGridNo;
	UINT8	ubID;
	SOLDIERTYPE *pSoldier;


	PlayJA2Sample( CAVE_COLLAPSE, RATE_11025, SoundVolume( HIGHVOLUME, sGridNo ), 1, SoundDir( sGridNo ) );
	for( y = -sRadius; y <= sRadius; y++ ) for( x = -sRadius; x <= sRadius; x++ )
	{
		sNewGridNo = sGridNo + y * WORLD_COLS + x;
		//Validate gridno location, and check if there are any mercs here.  If there are
		//any mercs, we want them to fall below.  The exitgrid already exists at this location
		if( GridNoOnVisibleWorldTile( sNewGridNo ) )
		{

			// Check if buddy exists here.....
			ubID = WhoIsThere2( sNewGridNo, 0 );

			if ( ubID != NOBODY )
			{
				// OK, make guy fall...
				// Set data to look for exit grid....
				pSoldier = MercPtrs[ ubID ];

				pSoldier->uiPendingActionData4 = sNewGridNo;

				EVENT_InitNewSoldierAnim( pSoldier, FALL_INTO_PIT, 0 , FALSE );
			}			
		}
	}
}

void HandleFallIntoPitFromAnimation( UINT8 ubID )
{
	SOLDIERTYPE *pSoldier = MercPtrs[ ubID ];
	EXITGRID ExitGrid;
	INT16 sPitGridNo;
	// OK, get exit grid...
	
	sPitGridNo = (INT16)pSoldier->uiPendingActionData4;

	GetExitGrid( sPitGridNo, &ExitGrid );

	// Given exit grid, make buddy move to next sector....
	pSoldier->ubStrategicInsertionCode = INSERTION_CODE_GRIDNO;
	pSoldier->usStrategicInsertionData = ExitGrid.usGridNo;

	pSoldier->sSectorX = ExitGrid.ubGotoSectorX;
	pSoldier->sSectorY = ExitGrid.ubGotoSectorY;
	pSoldier->bSectorZ = ExitGrid.ubGotoSectorZ;

	// Remove from world......
	RemoveSoldierFromTacticalSector( pSoldier, TRUE );

	HandleSoldierLeavingSectorByThemSelf( pSoldier );

	SetSoldierHeight( pSoldier, 0 );

}	